/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.furniture;

import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.furniture.FurnitureEntityAssetsByCategory;
import technology.rocketjump.undermount.assets.entities.furniture.model.FurnitureEntityAsset;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureCategoryDictionary;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;

@ProvidedBy(value=FurnitureEntityAssetDictionaryProvider.class)
@Singleton
public class FurnitureEntityAssetDictionary {
    private final Map<String, FurnitureEntityAsset> assetsByName = new HashMap<String, FurnitureEntityAsset>();
    private FurnitureEntityAssetsByCategory byCategory;

    public FurnitureEntityAssetDictionary(List<FurnitureEntityAsset> completeAssetList, FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary) {
        this.byCategory = new FurnitureEntityAssetsByCategory(categoryDictionary, layoutDictionary);
        for (FurnitureEntityAsset asset : completeAssetList) {
            this.assetsByName.put(asset.getUniqueName(), asset);
            this.byCategory.add(asset);
        }
    }

    public FurnitureEntityAsset getByUniqueName(String uniqueAssetName) {
        FurnitureEntityAsset asset = this.assetsByName.get(uniqueAssetName);
        if (asset != null) {
            return asset;
        }
        System.err.println("Could not find asset by name " + uniqueAssetName);
        return null;
    }

    public FurnitureEntityAsset getFurnitureEntityAsset(FurnitureEntityAttributes attributes) {
        return this.byCategory.get(attributes);
    }

    public List<FurnitureEntityAsset> getAllMatchingAssets(FurnitureEntityAttributes attributes) {
        return this.byCategory.getAll(attributes);
    }
}

